--[[ In the editor:
	* Xmin, XMax, YMin, YMax - projectile's trigger area
	* SpeedX - projectile speed (4 default)
	* Width - range (960pxs default)
	* Direction - direction (4 - left, 6 - Right)
	* Counter - time delay to next shoot (2000ms default)
	* Damage - damage (default 5)
    * User1 - if 1 - no sound
]]

function main(self)
	local claw = GetClaw()

	if self.State == 0 then
		self.timeCounter = 0
		if self.Counter == 0 then
			self.Counter = 2000
		end
		if self.SpeedX == 0 then
			self.SpeedX = 4
		end
		if self.Width == 0 then
			self.Width = 960
		end
		if self.Damage == 0 then
			local detector = GetObject(3206)
			local difficulty = detector.Difficulty
			self.Damage = difficulty == 2 and 15 or difficulty == 1 and 5 or 10
		end
		self.State = 1
	end

	if self.State > 0 then
		self.DrawFlags.NoDraw = self.I == 1
		self:AnimationStep()
	end

	if self.State == 1 and claw:InMinMax(self) then
		local speedX;
		if self.Direction == 4 then
			speedX = -self.SpeedX
		elseif self.Direction == 6 then
			speedX = self.SpeedX
		else
			self.State = 1000 -- block the logic
			return
		end

		self:SetAnimation("GAME_FORWARD50")

        if self.User[0] ~= 1 then
		    PlaySound("CLAW_ICESWORD")
		end

		CreateObject{
			X = self.X,
			Y = self.Y,
			Z = 4000,
			name = "WallFlame",
			SpeedX = speedX,
			Damage = self.Damage,
			Width = self.Width,
			Direction = self.Direction
		}

		self.timeCounter = GetTime() + self.Counter
		self.State = 2
	end

	if self.State == 2 and GetTime() > self.timeCounter then
		self:SetFrame(1)
		self.State = 1
	end
end
